Attribute VB_Name = "mdNewSketch"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Function NewSketch(workplane As aWorkplane, color As Integer, sketchName As String)

'Convenience Function to create a new sketch

'check if workplane is not null
If workplane Is Nothing Then
    Set NewSketch = Nothing
End If

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the Active PartDocument
Dim Part As PartDocument
Set Part = app.GetActiveDoc

If color < 0 Or color > 11 Then
        color = 4
End If

'check if sketch name is not null
If StrComp(sketchName, Null) Then
    MsgBox "Please enter a Sketch Name", vbOKOnly, "Error"
End If

'check if a sketch of the given name already exists
Dim searchSketch As aSketch
Set searchSketch = Part.LookupSketch(sketchName)

If searchSketch Is Nothing Then
    Set NewSketch = workplane.CreateSketch(sketchName)
Else
    MsgBox "A sketch alredy exists with that name.Please choose another name", vbOKOnly, "Error"
    Exit Function
End If

'Set the color for the sketch
Dim colorCls As ColorClass
Dim newColor As zColor
Set colorCls = app.GetClass("Color")
Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)
        
NewSketch.SetColor newColor

Part.SetActiveSketch NewSketch

End Function


